import requests
from bs4 import BeautifulSoup
import json

api='http://api.e-stat.go.jp/rest/2.1/app/json/getStatsData'
# アプリケーションIDはユーザ各自が申請してください
# id_str='bb4ae2edaa59b7a9e9b9ddb58719f2a1c11879ac' #アプリケーションID(架空)
id_data='0003448233'  #統計データの識別番号
url='{0}?appId={1}&statsDataId={2}'.format(api, id_str, id_data)
res=requests.get(url)  # HTTP プロトコルで Web API にアクセス
soup=BeautifulSoup(res.text)
data=json.loads(soup.text)   #  JSON 形式のデータを辞書型データに変換

data_stat=data['GET_STATS_DATA']['STATISTICAL_DATA']
print('**TITLE**', data_stat['TABLE_INF']['TITLE'])
area_class=data_stat['CLASS_INF']['CLASS_OBJ'][1]
print('**CLASS**',area_class['CLASS'][4])
a_value=data_stat['DATA_INF']['VALUE'][39]
print('**VALUE**',a_value)

for dic in area_class['CLASS']:
    if dic['@code']==a_value['@area']:
        print('**人口比率**',dic['@name'] , ':', a_value['$'], a_value['@unit'])

