import pandas as pd
import numpy as np
import matplotlib.pyplot as plt

class KMeans():
    def __init__(self,n_clusters=1):
        self.n_clusters=n_clusters

    def fit(self,X,epsilon=1e-10):
        self.init_centroid(X)
        while self.update(X) > epsilon:  
            pass
    def norm(self, vectors): 
        # 行ベクトルの2乗ノルムの配列を計算し返す
        return np.square(vectors).sum(axis=1)
        
    def update(self,X): 
        # Xの各行ベクトルには最も近いクラスタ中心のラベルを付けする
        k=self.n_clusters
        diff = [self.norm(X-self.centroids[nth]) for nth in range(k) ] 
        self.labels_= np.argmin(diff,axis= 0)     
        # ラベルを更新後に，同一ラベルを有する点の重心をクラスタ中心に設定する
        centroids=[ self.centroid_of_cluster(label,X) for label in range(k) ]
        diff_centroids=self.norm(np.array(centroids)-self.centroids)
        self.centroids=np.array(centroids)
        #クラスタ中心の更新前後での変位の2乗ノルムの合計を返す
        return np.nansum(diff_centroids)

    def centroid_of_cluster(self,label,X):
        return np.average( X[self.labels_==label,:], axis= 0)

    def init_centroid(self,X):
        self.labels_=np.empty(X.shape[0])
        self.centroids=np.empty((self.n_clusters,X.shape[1]))
        self.centroids[0]=X[0,:]
        for i in range(1,self.n_clusters):
            distance_list= [ self.norm(X-self.centroids[j]) for j in range(i)]
            nth=np.argmax(np.min(distance_list,axis=0))
            self.centroids[i]=X[nth,:]
          
df=pd.read_csv('data.csv')   # データの読み込み
X=np.array(df)       # データをNumpy 配列 X に格納
print(f'X.shape={X.shape}') 

model=KMeans(6)
model.fit(X)
plt.scatter(X[:,0], X[:,1], marker='.',c=model.labels_)
plt.savefig('prob6.5.19.pdf')
plt.show()
