# 利用モジュールのインポート
import pandas as pd

df= pd.read_csv('creditcard.csv')  # データはkaggleよりダウンロード 
dataY=df.loc[:,'Class']  # 教師データの抽出
dataX=df.drop(columns=['Class']).loc[:,:] # 説明データのみの抽出
# 学習データとテストデータの分割
from sklearn.model_selection import train_test_split   
X_train,X_test, Y_train,Y_test= train_test_split(dataX, dataY,\
test_size=0.33, stratify= dataY )   

#データ概要の出力
print(f'X_train.shape={X_train.shape}, X_test.shape={X_test.shape}')
print(f'Y_train.shape={Y_train.shape}, Y_test.shape={Y_test.shape}')
print(f'#(Y_train==1)={Y_train.sum()}, (Y_test==1)={Y_test.sum()}')

#説明データの標準化
from sklearn.preprocessing import StandardScaler
sX =StandardScaler()  
sX.fit( X_train  )   
X_train=sX.transform(X_train)
X_test=sX.transform(X_test)

#ロジスティック回帰によるモデル化
from sklearn.linear_model import LogisticRegression
model=LogisticRegression()  
model.fit(X_train, Y_train)   

# 検証データに対するモデル性能の評価
# ロジスティック予測確率値
predicted_Y_test = model.predict_proba(X_test)[:,1] 

# 検証データに対するRecall-Precision特性
from sklearn.metrics import precision_recall_curve, average_precision_score 
precision, recall, thresholds = precision_recall_curve(Y_test, predicted_Y_test)
av_pr_test=average_precision_score(Y_test, predicted_Y_test)
print(f'average precision(test)={av_pr_test}')

# 検証データに対するROC特性
from sklearn.metrics import roc_curve, auc 
fpr, tpr, thresholds = roc_curve(Y_test, predicted_Y_test)
areaUnderROC_test = auc(fpr, tpr)
print(f'AUC(test)={areaUnderROC_test}')
